"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationNotes = InvestigationNotes;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_user_profiles = require("../../../../hooks/use_fetch_user_profiles");
var _use_theme = require("../../../../hooks/use_theme");
var _investigation_context = require("../../contexts/investigation_context");
var _note = require("./note");
var _resizable_text_input = require("./resizable_text_input");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationNotes({
  user
}) {
  const theme = (0, _use_theme.useTheme)();
  const {
    investigation,
    addNote,
    isAddingNote
  } = (0, _investigation_context.useInvestigation)();
  const {
    data: userProfiles,
    isLoading: isLoadingUserProfiles
  } = (0, _use_fetch_user_profiles.useFetchUserProfiles)({
    profileIds: new Set(investigation === null || investigation === void 0 ? void 0 : investigation.notes.map(note => note.createdBy))
  });
  const [noteInput, setNoteInput] = (0, _react.useState)('');
  const onAddNote = async content => {
    await addNote(content);
    setNoteInput('');
  };
  const panelClassName = (0, _css.css)`
    background-color: ${theme.colors.lightShade};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasShadow: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    className: panelClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.investigateApp.investigationNotes.header', {
    defaultMessage: 'Notes'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, investigation === null || investigation === void 0 ? void 0 : investigation.notes.map(currNote => {
    return /*#__PURE__*/_react.default.createElement(_note.Note, {
      key: currNote.id,
      note: currNote,
      userProfile: userProfiles === null || userProfiles === void 0 ? void 0 : userProfiles[currNote.createdBy],
      userProfileLoading: isLoadingUserProfiles,
      isOwner: currNote.createdBy === user.profile_uid
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.investigateApp.investigationNotes.euiFormRow.notesLabel', {
      defaultMessage: 'Notes'
    })
  }, /*#__PURE__*/_react.default.createElement(_resizable_text_input.ResizableTextInput, {
    placeholder: _i18n.i18n.translate('xpack.investigateApp.investigationNotes.placeholder', {
      defaultMessage: 'Add a note to the investigation'
    }),
    disabled: isAddingNote,
    value: noteInput,
    onChange: value => {
      setNoteInput(value);
    },
    onSubmit: () => {
      onAddNote(noteInput.trim());
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "investigateAppInvestigationNotesAddButton",
    fullWidth: true,
    color: "primary",
    "aria-label": _i18n.i18n.translate('xpack.investigateApp.investigationNotes.addButtonLabel', {
      defaultMessage: 'Add'
    }),
    disabled: isAddingNote || noteInput.trim() === '',
    isLoading: isAddingNote,
    size: "m",
    onClick: () => {
      onAddNote(noteInput.trim());
    }
  }, _i18n.i18n.translate('xpack.investigateApp.investigationNotes.addButtonLabel', {
    defaultMessage: 'Add'
  }))))));
}