"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditNoteForm = EditNoteForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _resizable_text_input = require("./resizable_text_input");
var _investigation_context = require("../../contexts/investigation_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditNoteForm({
  note,
  onClose
}) {
  const [noteInput, setNoteInput] = (0, _react.useState)(note.content);
  const {
    updateNote,
    isUpdatingNote
  } = (0, _investigation_context.useInvestigation)();
  const onUpdate = async () => {
    await updateNote(note.id, noteInput.trim());
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_resizable_text_input.ResizableTextInput, {
    disabled: isUpdatingNote,
    value: noteInput,
    onChange: value => {
      setNoteInput(value);
    },
    onSubmit: onUpdate,
    placeholder: note.content
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isUpdatingNote,
    "data-test-subj": "cancelEditNoteButton",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.investigateApp.investigationNotes.cancelEditButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    size: "m",
    onClick: () => onClose()
  }, _i18n.i18n.translate('xpack.investigateApp.investigationNotes.cancelEditButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "updateNoteButton",
    color: "primary",
    "aria-label": _i18n.i18n.translate('xpack.investigateApp.investigationNotes.updateNoteButtonLabel', {
      defaultMessage: 'Update note'
    }),
    disabled: isUpdatingNote || noteInput.trim() === '',
    isLoading: isUpdatingNote,
    size: "m",
    onClick: onUpdate
  }, _i18n.i18n.translate('xpack.investigateApp.investigationNotes.updateNoteButtonLabel', {
    defaultMessage: 'Update note'
  })))));
}