"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationItems = InvestigationItems;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _events_timeline = require("../events_timeline/events_timeline");
var _investigation_context = require("../../contexts/investigation_context");
var _add_investigation_item = require("../add_investigation_item/add_investigation_item");
var _investigation_items_list = require("../investigation_items_list/investigation_items_list");
var _investigation_search_bar = require("../investigation_search_bar/investigation_search_bar");
var _assistant_hypothesis = require("../assistant_hypothesis/assistant_hypothesis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationItems() {
  const {
    globalParams,
    updateInvestigationParams,
    investigation
  } = (0, _investigation_context.useInvestigation)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_investigation_search_bar.InvestigationSearchBar, {
    dateRangeFrom: globalParams.timeRange.from,
    dateRangeTo: globalParams.timeRange.to,
    onQuerySubmit: async ({
      dateRange
    }) => {
      const nextTimeRange = {
        from: _datemath.default.parse(dateRange.from).toISOString(),
        to: _datemath.default.parse(dateRange.to).toISOString()
      };
      updateInvestigationParams({
        timeRange: nextTimeRange
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_events_timeline.EventsTimeLine, null)), (investigation === null || investigation === void 0 ? void 0 : investigation.id) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_assistant_hypothesis.AssistantHypothesis, {
    investigationId: investigation.id
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_investigation_items_list.InvestigationItemsList, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_add_investigation_item.AddInvestigationItem, null));
}