"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalIncidentButton = ExternalIncidentButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _investigation_context = require("../../contexts/investigation_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExternalIncidentButton() {
  const {
    investigation
  } = (0, _investigation_context.useInvestigation)();
  if (!(investigation !== null && investigation !== void 0 && investigation.externalIncidentUrl)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "externalIncidentHeaderButton",
    iconType: "link",
    size: "xs",
    href: investigation.externalIncidentUrl,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.investigateApp.investigationHeader.externalIncidentTextLabel', {
    defaultMessage: 'External incident'
  })));
}