"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsButton = AlertDetailsButton;
var _eui = require("@elastic/eui");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_fetch_alert = require("../../../../hooks/use_fetch_alert");
var _investigation_context = require("../../contexts/investigation_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertDetailsButton() {
  const {
    core: {
      http: {
        basePath
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    investigation
  } = (0, _investigation_context.useInvestigation)();
  const {
    data: alertDetails
  } = (0, _use_fetch_alert.useFetchAlert)({
    investigation
  });
  if (!alertDetails) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "investigationDetailsAlertLink",
    iconType: "arrowLeft",
    size: "xs",
    href: basePath.prepend(`/app/observability/alerts/${alertDetails[_technical_rule_data_field_names.ALERT_UUID]}`)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, `[Alert] ${alertDetails === null || alertDetails === void 0 ? void 0 : alertDetails[_technical_rule_data_field_names.ALERT_RULE_CATEGORY]} breached`));
}