"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationEvent = AnnotationEvent;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AnnotationEvent({
  event
}) {
  const timestamp = event.timestamp;
  return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: event.id,
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: (0, _moment.default)(timestamp).valueOf(),
      details: event.description,
      header: (0, _moment.default)(event.timestamp).format('lll')
    }],
    marker: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      style: {
        marginTop: -16
      },
      type: "dot",
      size: "l"
    })),
    markerPosition: "bottom"
  });
}