"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantHypothesis = AssistantHypothesis;
var _dedent = _interopRequireDefault(require("dedent"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _investigation_context = require("../../contexts/investigation_context");
var _use_fetch_entities = require("../../../../hooks/use_fetch_entities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AssistantHypothesis({
  investigationId
}) {
  const {
    alert
  } = (0, _investigation_context.useInvestigation)();
  const {
    dependencies: {
      start: {
        observabilityAIAssistant: {
          ObservabilityAIAssistantContextualInsight,
          getContextualInsightMessages
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data: entitiesData
  } = (0, _use_fetch_entities.useFetchEntities)({
    investigationId,
    serviceName: alert !== null && alert !== void 0 && alert['service.name'] ? `${alert === null || alert === void 0 ? void 0 : alert['service.name']}` : undefined,
    serviceEnvironment: alert !== null && alert !== void 0 && alert['service.environment'] ? `${alert === null || alert === void 0 ? void 0 : alert['service.environment']}` : undefined,
    hostName: alert !== null && alert !== void 0 && alert['host.name'] ? `${alert === null || alert === void 0 ? void 0 : alert['host.name']}` : undefined,
    containerId: alert !== null && alert !== void 0 && alert['container.id'] ? `${alert === null || alert === void 0 ? void 0 : alert['container.id']}` : undefined
  });
  const getAlertContextMessages = (0, _react.useCallback)(async () => {
    var _entitiesData$entitie;
    if (!getContextualInsightMessages || !alert) {
      return [];
    }
    const entities = (_entitiesData$entitie = entitiesData === null || entitiesData === void 0 ? void 0 : entitiesData.entities) !== null && _entitiesData$entitie !== void 0 ? _entitiesData$entitie : [];
    const entityContext = entities !== null && entities !== void 0 && entities.length ? `
      Alerts can optionally be associated with entities. Entities can be services, hosts, containers, or other resources. Entities can have metrics associated with them. 
      
      The alert that triggered this investigation is associated with the following entities: ${entities.map((entity, index) => {
      return (0, _dedent.default)(`
            ## Entity ${index + 1}:
            ${formatEntityMetrics(entity)};
          `);
    }).join('/n/n')}` : '';
    return getContextualInsightMessages({
      message: `I am investigating a failure in my system. I was made aware of the failure by an alert and I am trying to understand the root cause of the issue.`,
      instructions: (0, _dedent.default)(`I'm an SRE. I am investigating a failure in my system. I was made aware of the failure via an alert. Your current task is to help me identify the root cause of the failure in my system.

        The rule that triggered the alert is a ${alert[_ruleDataUtils.ALERT_RULE_CATEGORY]} rule. The alert started at ${alert[_ruleDataUtils.ALERT_START]}. The alert reason is ${alert[_ruleDataUtils.ALERT_REASON]}. The rule parameters are ${JSON.stringify(_ruleDataUtils.ALERT_RULE_PARAMETERS)}.

        ${entityContext}

        Based on the alert details, suggest a root cause and next steps to mitigate the issue. 
        
        I do not have the alert details or entity details in front of me, so be sure to repeat the alert reason (${alert[_ruleDataUtils.ALERT_REASON]}), when the alert was triggered (${alert[_ruleDataUtils.ALERT_START]}), and the entity metrics in your response.

        When displaying the entity metrics, please convert the metrics to a human-readable format. For example, convert "logRate" to "Log Rate" and "errorRate" to "Error Rate".
        `)
    });
  }, [alert, getContextualInsightMessages, entitiesData === null || entitiesData === void 0 ? void 0 : entitiesData.entities]);
  if (!ObservabilityAIAssistantContextualInsight) {
    return null;
  }
  return alert && entitiesData ? /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: _i18n.i18n.translate('xpack.investigateApp.assistantHypothesis.observabilityAIAssistantContextualInsight.helpMeInvestigateThisLabel', {
      defaultMessage: 'Help me investigate this failure'
    }),
    messages: getAlertContextMessages
  }) : null;
}
const formatEntityMetrics = entity => {
  const entityMetrics = Object.entries(entity.metrics).map(([key, value]) => `${key}: ${value}`).join(', ');
  const entitySources = entity.sources.map(source => source.dataStream).join(', ');
  return (0, _dedent.default)(`
    Entity name: ${entity.display_name}; 
    Entity type: ${entity.type}; 
    Entity metrics: ${entityMetrics}; 
    Entity data streams: ${entitySources}
  `);
};