"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlWidgetPreview = EsqlWidgetPreview;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _use_abortable_async = require("@kbn/observability-utils/hooks/use_abortable_async");
var _react = _interopRequireWildcard(require("react"));
var _error_message = require("../../../../components/error_message");
var _suggest_visualization_list = require("../../../../components/suggest_visualization_list");
var _use_kibana = require("../../../../hooks/use_kibana");
var _get_date_histogram_results = require("../../../../items/esql_item/get_date_histogram_results");
var _register_esql_item = require("../../../../items/esql_item/register_esql_item");
var _get_es_filter_from_overrides = require("../../../../utils/get_es_filter_from_overrides");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getItemFromSuggestion({
  query,
  suggestion
}) {
  return {
    title: suggestion.title,
    type: _register_esql_item.ESQL_ITEM_TYPE,
    params: {
      esql: query,
      suggestion
    }
  };
}
function PreviewContainer({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center",
    className: (0, _css.css)`
        padding: 24px 0px 24px 0px;
        width: 100%;
        overflow: auto;
        > div {
          width: 100%;
        }
      `
  }, children);
}
function EsqlWidgetPreview({
  esqlQuery,
  onItemAdd,
  timeRange
}) {
  const {
    services: {
      esql
    }
  } = (0, _use_kibana.useKibana)();
  const filter = (0, _react.useMemo)(() => {
    return (0, _get_es_filter_from_overrides.getEsFilterFromOverrides)({
      timeRange
    });
  }, [timeRange]);
  const [selectedSuggestion, setSelectedSuggestion] = (0, _react.useState)(undefined);
  const queryResult = (0, _use_abortable_async.useAbortableAsync)(async ({
    signal
  }) => {
    return await esql.queryWithMeta({
      signal,
      query: esqlQuery,
      filter
    }).then(result => {
      setSelectedSuggestion(prevSuggestion => {
        const mostSimilarSuggestion = result.meta.suggestions.find(suggestion => suggestion.visualizationId === (prevSuggestion === null || prevSuggestion === void 0 ? void 0 : prevSuggestion.visualizationId)) || result.meta.suggestions[0];
        return mostSimilarSuggestion;
      });
      return result;
    });
  }, [esqlQuery, filter, esql]);
  const dateHistoResponse = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    var _queryResult$value, _queryResult$value$qu;
    if (!((_queryResult$value = queryResult.value) !== null && _queryResult$value !== void 0 && (_queryResult$value$qu = _queryResult$value.query) !== null && _queryResult$value$qu !== void 0 && _queryResult$value$qu.values) || queryResult.loading || !selectedSuggestion) {
      return undefined;
    }
    return (0, _get_date_histogram_results.getDateHistogramResults)({
      columns: queryResult.value.query.columns,
      esql,
      filter,
      query: esqlQuery,
      signal,
      suggestion: selectedSuggestion,
      timeRange
    });
  }, [queryResult, esql, filter, esqlQuery, selectedSuggestion, timeRange]);
  const [displayedProps, setDisplayedProps] = (0, _react.useState)({
    loading: true,
    value: undefined,
    error: undefined
  });
  (0, _react.useEffect)(() => {
    setDisplayedProps(prevDisplayedProps => {
      if (queryResult.loading) {
        return {
          ...prevDisplayedProps,
          loading: true,
          error: undefined
        };
      }
      return {
        error: queryResult.error,
        loading: queryResult.loading,
        value: queryResult.value ? {
          columns: queryResult.value.query.columns,
          values: queryResult.value.query.values,
          allColumns: queryResult.value.query.all_columns,
          dataView: queryResult.value.meta.dataView,
          suggestions: queryResult.value.meta.suggestions
        } : undefined
      };
    });
  }, [queryResult]);
  if (displayedProps.error) {
    return /*#__PURE__*/_react.default.createElement(PreviewContainer, null, /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessage, {
      error: displayedProps.error
    }));
  }
  if (!displayedProps.value || !selectedSuggestion) {
    return /*#__PURE__*/_react.default.createElement(PreviewContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(PreviewContainer, null, /*#__PURE__*/_react.default.createElement(_register_esql_item.EsqlWidget, {
    suggestion: selectedSuggestion,
    dataView: displayedProps.value.dataView,
    esqlQuery: esqlQuery,
    dateHistogramResults: dateHistoResponse.value
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_suggest_visualization_list.SuggestVisualizationList, {
    suggestions: displayedProps.value.suggestions,
    onSuggestionClick: suggestion => {
      onItemAdd(getItemFromSuggestion({
        query: esqlQuery,
        suggestion
      }));
    },
    loading: queryResult.loading,
    onMouseLeave: () => {},
    onSuggestionRollOver: suggestion => {
      setSelectedSuggestion(suggestion);
    }
  })));
}