"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFromLibraryButton = AddFromLibraryButton;
var _uuid = require("uuid");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _register_embeddable_item = require("../../../../items/embeddable_item/register_embeddable_item");
var _use_kibana = require("../../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddFromLibraryButton({
  onItemAdd
}) {
  const {
    dependencies: {
      start: {
        contentManagement
      }
    }
  } = (0, _use_kibana.useKibana)();
  const panelRef = (0, _react.useRef)();
  const container = (0, _react.useMemo)(() => {
    function addEmbeddable({
      type,
      title,
      attributes,
      savedObjectId
    }) {
      const embeddableItem = {
        title,
        type: _register_embeddable_item.EMBEDDABLE_ITEM_TYPE,
        params: {
          savedObjectId,
          config: {},
          type
        }
      };
      onItemAdd(embeddableItem).then(() => {
        if (panelRef.current) {
          panelRef.current.close();
        }
      });
    }
    return {
      addNewPanel: async (panel, displaySuccessMessage) => {
        const state = panel.initialState;
        const savedObject = await contentManagement.client.get({
          contentTypeId: panel.panelType,
          id: state.savedObjectId
        });
        addEmbeddable({
          type: panel.panelType,
          savedObjectId: state.savedObjectId,
          attributes: {},
          title: savedObject.item.attributes.title
        });
        return undefined;
      },
      addNewEmbeddable: async (type, explicitInput, attributes) => {
        var _attributes$title;
        addEmbeddable({
          type,
          title: (_attributes$title = attributes.title) !== null && _attributes$title !== void 0 ? _attributes$title : '',
          savedObjectId: explicitInput.savedObjectId,
          attributes
        });
        return {
          id: (0, _uuid.v4)()
        };
      }
    };
  }, [contentManagement.client, onItemAdd]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "investigateAppAddFromLibraryButtonImportFromLibraryButton",
    iconType: "importAction",
    onClick: () => {
      panelRef.current = (0, _public.openAddPanelFlyout)({
        container
      });
      panelRef.current.onClose.then(() => {
        panelRef.current = undefined;
      });
    }
  }, _i18n.i18n.translate('xpack.investigateApp.addFromLibraryButtonLabel', {
    defaultMessage: 'Import from library'
  }));
}