"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensFieldFormat = void 0;
exports.LensWidget = LensWidget;
exports.registerLensItem = registerLensItem;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuery = {
  language: 'kuery',
  query: ''
};
const LensFieldFormat = exports.LensFieldFormat = {
  NUMBER: 'number',
  PERCENT: 'percent',
  BITS: 'bits'
};
function LensWidget({
  timeRange,
  searchConfiguration,
  equation,
  interval,
  filters,
  groupBy
}) {
  const {
    dependencies: {
      start: {
        lens,
        data
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [attributes, setAttributes] = (0, _react.useState)();
  const [chartLoading, setChartLoading] = (0, _react.useState)(false);
  const formulaAsync = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);
  const [dataView, setDataView] = (0, _react.useState)();
  const [, setDataViewError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const initDataView = async () => {
      const ruleSearchConfiguration = searchConfiguration;
      try {
        const createdSearchSource = await data.search.searchSource.create(ruleSearchConfiguration);
        setDataView(createdSearchSource.getField('index'));
      } catch (error) {
        setDataViewError(error);
      }
    };
    initDataView();
  }, [data.search.searchSource, searchConfiguration]);

  // Handle Lens error
  (0, _react.useEffect)(() => {
    // Lens does not expose or provide a way to check if there is an error in the chart, yet.
    // To work around this, we check if the element with class 'lnsEmbeddedError' is found in the DOM.
    setTimeout(function () {
      const errorDiv = document.querySelector('.lnsEmbeddedError');
      if (errorDiv) {
        const paragraphElements = errorDiv.querySelectorAll('p');
        if (!paragraphElements || paragraphElements.length < 2) return;
        paragraphElements[0].innerText = _i18n.i18n.translate('xpack.investigateApp.defaultChart.error_equation.title', {
          defaultMessage: 'An error occurred while rendering the chart'
        });
        paragraphElements[1].innerText = _i18n.i18n.translate('xpack.investigateApp.defaultChart.error_equation.description', {
          defaultMessage: 'Check the equation.'
        });
      }
    });
  }, [chartLoading, attributes]);
  (0, _react.useEffect)(() => {
    if (!formulaAsync.value || !dataView || !equation) {
      return;
    }
    const baseLayer = {
      type: 'formula',
      value: equation,
      label: equation,
      groupBy
    };
    const xYDataLayerOptions = {
      buckets: {
        type: 'date_histogram',
        params: {
          interval
        }
      },
      seriesType: 'bar_stacked'
    };
    if (groupBy && groupBy !== null && groupBy !== void 0 && groupBy.length) {
      xYDataLayerOptions.breakdown = {
        type: 'top_values',
        field: groupBy[0],
        params: {
          size: 3,
          secondaryFields: groupBy.slice(1),
          accuracyMode: false
        }
      };
    }
    const xyDataLayer = new _lensEmbeddableUtils.XYDataLayer({
      data: [baseLayer].map(layer => ({
        type: layer.type,
        value: layer.value,
        label: layer.label
      })),
      options: xYDataLayerOptions
    });
    const layers = [xyDataLayer];
    const attributesLens = new _lensEmbeddableUtils.LensAttributesBuilder({
      visualization: new _lensEmbeddableUtils.XYChart({
        layers,
        formulaAPI: formulaAsync.value.formula,
        dataView
      })
    }).build();
    const lensBuilderAtt = {
      ...attributesLens,
      type: 'lens'
    };
    setAttributes(lensBuilderAtt);
  }, [searchConfiguration, equation, groupBy, interval, dataView, formulaAsync.value]);
  if (!dataView || !attributes || !timeRange) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        maxHeight: 180,
        minHeight: 180
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visArea",
      titleSize: "xxs",
      "data-test-subj": "investigateAppNoChartData",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.investigateApp.defaultChart.noData.title",
        defaultMessage: "No chart data available"
      })
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, {
    onLoad: setChartLoading,
    id: "alertDefaultChart",
    style: {
      height: 128
    },
    timeRange: timeRange,
    attributes: attributes,
    query: (searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.query) || defaultQuery,
    disableTriggers: true,
    filters: filters,
    overrides: {
      axisX: {
        hide: true
      },
      axisLeft: {
        style: {
          axisTitle: {
            visible: false
          }
        }
      },
      settings: {
        showLegend: false
      }
    }
  }));
}
function registerLensItem({
  dependencies: {
    setup: {
      investigate
    }
  }
}) {
  investigate.registerItemDefinition({
    type: 'lens',
    generate: async () => {
      return {};
    },
    render: option => {
      const {
        itemParams,
        globalParams
      } = option;
      return /*#__PURE__*/_react.default.createElement(LensWidget, {
        equation: itemParams.equation,
        searchConfiguration: itemParams.searchConfiguration,
        interval: itemParams.interval,
        filters: itemParams.filters,
        groupBy: itemParams.groupBy,
        timeRange: globalParams.timeRange
      });
    }
  });
}