"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMBEDDABLE_ITEM_TYPE = void 0;
exports.registerEmbeddableItem = registerEmbeddableItem;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _public = require("@kbn/embeddable-plugin/public");
var _use_abortable_async = require("@kbn/observability-utils/hooks/use_abortable_async");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _error_message = require("../../components/error_message");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMBEDDABLE_ITEM_TYPE = exports.EMBEDDABLE_ITEM_TYPE = 'embeddable';
const embeddableClassName = (0, _css.css)`
  height: 100%;
  > [data-shared-item] {
    height: 100%;
  }
`;
function ReactEmbeddable({
  type,
  config,
  timeRange: {
    from,
    to
  },
  savedObjectId
}) {
  const configWithOverrides = (0, _react.useMemo)(() => {
    return {
      ...config,
      timeRange: {
        from,
        to
      },
      savedObjectId
    };
  }, [config, from, to, savedObjectId]);
  const configWithOverridesRef = (0, _react.useRef)(configWithOverrides);
  configWithOverridesRef.current = configWithOverrides;
  const api = (0, _react.useMemo)(() => {
    return {
      getSerializedStateForChild: () => ({
        rawState: configWithOverridesRef.current
      })
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableClassName
  }, /*#__PURE__*/_react.default.createElement(_public.ReactEmbeddableRenderer, {
    type: type,
    getParentApi: () => api,
    maybeId: savedObjectId,
    hidePanelChrome: true
  }));
}
function LegacyEmbeddable({
  type,
  config,
  timeRange: {
    from,
    to
  },
  savedObjectId
}) {
  const {
    dependencies: {
      start: {
        embeddable
      }
    }
  } = (0, _use_kibana.useKibana)();
  const [targetElement, setTargetElement] = (0, _react.useState)(null);
  const embeddableInstanceAsync = (0, _use_abortable_async.useAbortableAsync)(async () => {
    const factory = embeddable.getEmbeddableFactory(type);
    if (!factory) {
      throw new Error(`Cannot find embeddable factory for ${type}`);
    }
    const configWithId = {
      id: savedObjectId !== null && savedObjectId !== void 0 ? savedObjectId : (0, _uuid.v4)(),
      ...config
    };
    const configWithOverrides = {
      ...configWithId,
      timeRange: {
        from,
        to
      },
      overrides: {
        axisX: {
          hide: true
        },
        axisLeft: {
          style: {
            axisTitle: {
              visible: false
            }
          }
        },
        settings: {
          showLegend: false
        }
      }
    };
    if (savedObjectId) {
      return factory.createFromSavedObject(configWithOverrides.id, configWithOverrides);
    }
    const instance = await factory.create(configWithOverrides);
    return instance;
  }, [type, savedObjectId, config, from, to, embeddable]);
  const embeddableInstance = embeddableInstanceAsync.value;
  (0, _react.useEffect)(() => {
    if (!targetElement || !embeddableInstance) {
      return;
    }
    embeddableInstance.render(targetElement);
    return () => {};
  }, [embeddableInstance, targetElement]);
  (0, _react.useEffect)(() => {
    return () => {
      if (embeddableInstance) {
        embeddableInstance.destroy();
      }
    };
  }, [embeddableInstance]);
  if (embeddableInstanceAsync.error) {
    return /*#__PURE__*/_react.default.createElement(_error_message.ErrorMessage, {
      error: embeddableInstanceAsync.error
    });
  }
  if (!embeddableInstance) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableClassName,
    ref: element => {
      setTargetElement(element);
    }
  });
}
function EmbeddableWidget(props) {
  const {
    dependencies: {
      start: {
        embeddable
      }
    }
  } = (0, _use_kibana.useKibana)();
  if (embeddable.reactEmbeddableRegistryHasKey(props.type)) {
    return /*#__PURE__*/_react.default.createElement(ReactEmbeddable, props);
  }
  return /*#__PURE__*/_react.default.createElement(LegacyEmbeddable, props);
}
function registerEmbeddableItem({
  dependencies: {
    setup: {
      investigate
    }
  },
  services
}) {
  investigate.registerItemDefinition({
    type: EMBEDDABLE_ITEM_TYPE,
    generate: async option => {
      return {};
    },
    render: option => {
      const parameters = {
        type: option.itemParams.type,
        config: option.itemParams.config,
        savedObjectId: option.itemParams.savedObjectId,
        timeRange: option.globalParams.timeRange
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        className: (0, _css.css)`
            > div {
              height: 128px;
            }
          `
      }, /*#__PURE__*/_react.default.createElement(EmbeddableWidget, parameters));
    }
  });
}