"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchInvestigationList = useFetchInvestigationList;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _query_key_factory = require("./query_key_factory");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = 25;
function useFetchInvestigationList({
  page = 1,
  perPage = DEFAULT_PAGE_SIZE,
  search,
  filter
} = {}) {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.list({
      page,
      perPage,
      search,
      filter
    }),
    queryFn: async ({
      signal
    }) => {
      return await http.get(`/api/observability/investigations`, {
        version: '2023-10-31',
        query: {
          ...(page !== undefined && {
            page
          }),
          ...(perPage !== undefined && {
            perPage
          }),
          ...(!!search && {
            search
          }),
          ...(!!filter && {
            filter
          })
        },
        signal
      });
    },
    retry: false,
    refetchInterval: 60 * 1000,
    refetchOnWindowFocus: false,
    cacheTime: 600 * 1000,
    // 10 minutes
    staleTime: 0,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.investigateApp.useFetchInvestigationList.errorTitle', {
          defaultMessage: 'Something went wrong while fetching investigations'
        })
      });
    }
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}