"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAllInvestigationStats = useFetchAllInvestigationStats;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _query_key_factory = require("./query_key_factory");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchAllInvestigationStats() {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.stats(),
    queryFn: async ({
      signal
    }) => {
      var _response$count$triag, _response$count$activ, _response$count$mitig, _response$count$resol, _response$count$cance, _response$total;
      const response = await http.get(`/api/observability/investigations/_stats`, {
        version: '2023-10-31',
        signal
      });
      return {
        count: {
          triage: (_response$count$triag = response.count.triage) !== null && _response$count$triag !== void 0 ? _response$count$triag : 0,
          active: (_response$count$activ = response.count.active) !== null && _response$count$activ !== void 0 ? _response$count$activ : 0,
          mitigated: (_response$count$mitig = response.count.mitigated) !== null && _response$count$mitig !== void 0 ? _response$count$mitig : 0,
          resolved: (_response$count$resol = response.count.resolved) !== null && _response$count$resol !== void 0 ? _response$count$resol : 0,
          cancelled: (_response$count$cance = response.count.cancelled) !== null && _response$count$cance !== void 0 ? _response$count$cance : 0
        },
        total: (_response$total = response.total) !== null && _response$total !== void 0 ? _response$total : 0
      };
    },
    retry: false,
    cacheTime: 600 * 1000,
    // 10 minutes
    staleTime: 0,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.investigateApp.useFetchAllInvestigationStats.errorTitle', {
          defaultMessage: 'Something went wrong while fetching the investigation stats'
        })
      });
    }
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}