"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAlert = useFetchAlert;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/rule-registry-plugin/common");
var _investigationShared = require("@kbn/investigation-shared");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchAlert({
  investigation
}) {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const alertOriginInvestigation = _investigationShared.alertOriginSchema.safeParse(investigation === null || investigation === void 0 ? void 0 : investigation.origin);
  const alertId = alertOriginInvestigation.success ? alertOriginInvestigation.data.id : undefined;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchAlert', investigation === null || investigation === void 0 ? void 0 : investigation.id],
    queryFn: async ({
      signal
    }) => {
      return await http.get(_common.BASE_RAC_ALERTS_API_PATH, {
        query: {
          id: alertId
        },
        signal
      });
    },
    staleTime: 60 * 1000,
    refetchOnWindowFocus: false,
    onError: error => {
      toasts.addError(error, {
        title: 'Something went wrong while fetching alert'
      });
    },
    enabled: Boolean(alertId)
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}