"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteInvestigationNote = useDeleteInvestigationNote;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDeleteInvestigationNote() {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useMutation)(['deleteInvestigationNote'], ({
    investigationId,
    noteId
  }) => {
    return http.delete(`/api/observability/investigations/${investigationId}/notes/${noteId}`, {
      version: '2023-10-31'
    });
  }, {
    onSuccess: (response, {}) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.investigateApp.useDeleteInvestigationNote.successMessage', {
        defaultMessage: 'Note deleted'
      }));
    },
    onError: (error, {}, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : _i18n.i18n.translate('xpack.investigateApp.useDeleteInvestigationNote.errorMessage', {
        defaultMessage: 'an error occurred'
      })), {
        title: _i18n.i18n.translate('xpack.investigateApp.useDeleteInvestigationNote.errorTitle', {
          defaultMessage: 'Error'
        })
      });
    }
  });
}