"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewLensSuggestion = PreviewLensSuggestion;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Container({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children));
}
const panelContainerClassName = (0, _css.css)`
  overflow: clip auto;
  height: 100%;
`;
const panelContentClassName = (0, _css.css)`
  height: 100%;
  overflow: clip auto;
  > div {
    height: 100%;
  }
`;
function PreviewLensSuggestion({
  input,
  loading,
  error
}) {
  const {
    dependencies: {
      start: {
        lens
      }
    }
  } = (0, _use_kibana.useKibana)();
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: true,
    className: panelContainerClassName
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: panelContentClassName
  }, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, input)));
}