"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationEditForm = InvestigationEditForm;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _paths = require("../../../common/paths");
var _use_create_investigation = require("../../hooks/use_create_investigation");
var _use_fetch_investigation = require("../../hooks/use_fetch_investigation");
var _use_kibana = require("../../hooks/use_kibana");
var _use_update_investigation = require("../../hooks/use_update_investigation");
var _investigation_not_found = require("../investigation_not_found/investigation_not_found");
var _external_incident_field = require("./fields/external_incident_field");
var _status_field = require("./fields/status_field");
var _tags_field = require("./fields/tags_field");
var _form_helper = require("./form_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationEditForm({
  investigationId,
  onClose
}) {
  const {
    core: {
      http: {
        basePath
      },
      application: {
        navigateToUrl
      }
    }
  } = (0, _use_kibana.useKibana)();
  const isEditing = Boolean(investigationId);
  const {
    data: investigation,
    isLoading,
    isError
  } = (0, _use_fetch_investigation.useFetchInvestigation)({
    id: investigationId
  });
  const {
    mutateAsync: updateInvestigation
  } = (0, _use_update_investigation.useUpdateInvestigation)();
  const {
    mutateAsync: createInvestigation
  } = (0, _use_create_investigation.useCreateInvestigation)();
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: {
      title: _i18n.i18n.translate('xpack.investigateApp.investigationDetailsPage.newInvestigationLabel', {
        defaultMessage: 'New investigation'
      }),
      status: 'triage',
      tags: [],
      externalIncidentUrl: null
    },
    values: investigation ? (0, _lodash.pick)(investigation, ['title', 'status', 'tags', 'externalIncidentUrl']) : undefined,
    mode: 'all'
  });
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_investigation_not_found.InvestigationNotFound, null);
  }
  if (isEditing && (isLoading || !investigation)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    });
  }
  const onSubmit = async data => {
    if (isEditing) {
      await updateInvestigation({
        investigationId: investigationId,
        payload: (0, _form_helper.toUpdateInvestigationParams)(data)
      });
      onClose();
    } else {
      const resp = await createInvestigation((0, _form_helper.toCreateInvestigationParams)(data));
      navigateToUrl(basePath.prepend(_paths.paths.investigationDetails(resp.id)));
    }
  };
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: methods.handleSubmit(onSubmit)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: () => onClose(),
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isEditing ? _i18n.i18n.translate('xpack.investigateApp.investigationDetailsPage.h2.editLabel', {
    defaultMessage: 'Edit'
  }) : _i18n.i18n.translate('xpack.investigateApp.investigationDetailsPage.h2.createLabel', {
    defaultMessage: 'Create'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.investigateApp.investigationEditForm.span.titleLabel', {
      defaultMessage: 'Title'
    }),
    isInvalid: methods.getFieldState('title').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "title",
    control: methods.control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
      fullWidth: true,
      "data-test-subj": "titleInput",
      required: true,
      isInvalid: fieldState.invalid,
      value: field.value,
      onChange: event => field.onChange(event.target.value)
    }))
  }))), isEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_status_field.StatusField, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_tags_field.TagsField, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_external_incident_field.ExternalIncidentField, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "closeBtn",
    iconType: "cross",
    onClick: () => onClose(),
    flush: "left"
  }, _i18n.i18n.translate('xpack.investigateApp.investigationDetailsPage.closeButtonEmptyLabel', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "saveBtn",
    onClick: methods.handleSubmit(onSubmit),
    fill: true
  }, _i18n.i18n.translate('xpack.investigateApp.investigationDetailsPage.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))))));
}