"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Application = Application;
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQuery = require("@tanstack/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _react = _interopRequireWildcard(require("react"));
var _investigate_app_context_provider = require("./components/investigate_app_context_provider");
var _config = require("./routes/config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryClient = new _reactQuery.QueryClient();
function Application({
  coreStart,
  history,
  pluginsStart,
  theme$,
  services
}) {
  const theme = (0, _react.useMemo)(() => {
    return {
      theme$
    };
  }, [theme$]);
  const context = (0, _react.useMemo)(() => ({
    core: coreStart,
    dependencies: {
      start: pluginsStart
    },
    services
  }), [coreStart, pluginsStart, services]);
  const App = () => {
    const routes = (0, _config.getRoutes)();
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, Object.keys(routes).map(path => {
      const {
        handler,
        exact
      } = routes[path];
      const Wrapper = () => {
        return handler();
      };
      return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
        key: path,
        path: path,
        exact: exact,
        component: Wrapper
      });
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: theme
  }, /*#__PURE__*/_react.default.createElement(_investigate_app_context_provider.InvestigateAppContextProvider, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: coreStart
  }, /*#__PURE__*/_react.default.createElement(coreStart.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(App, null), /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  })))))));
}