"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCallInvestigateAppAPI = createCallInvestigateAppAPI;
var _format_request = require("@kbn/server-route-repository-utils/src/format_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createCallInvestigateAppAPI(core) {
  return (endpoint, options) => {
    const {
      params
    } = options;
    const {
      method,
      pathname,
      version
    } = (0, _format_request.formatRequest)(endpoint, params === null || params === void 0 ? void 0 : params.path);
    return core.http[method](pathname, {
      ...options,
      body: params && params.body ? JSON.stringify(params.body) : undefined,
      query: params === null || params === void 0 ? void 0 : params.query,
      version
    });
  };
}