"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasDataRoutes = exports.hasDataRoute = void 0;
var _create_observability_es_client = require("@kbn/observability-utils/es/client/create_observability_es_client");
var _constants = require("@kbn/deeplinks-observability/constants");
var _create_inventory_server_route = require("../create_inventory_server_route");
var _get_has_data = require("./get_has_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasDataRoute = exports.hasDataRoute = (0, _create_inventory_server_route.createInventoryServerRoute)({
  endpoint: 'GET /internal/inventory/has_data',
  options: {
    tags: ['access:inventory']
  },
  handler: async ({
    context,
    logger
  }) => {
    const coreContext = await context.core;
    const inventoryEsClient = (0, _create_observability_es_client.createObservabilityEsClient)({
      client: coreContext.elasticsearch.client.asCurrentUser,
      logger,
      plugin: `@kbn/${_constants.INVENTORY_APP_ID}-plugin`
    });
    return (0, _get_has_data.getHasData)({
      inventoryEsClient,
      logger
    });
  }
});
const hasDataRoutes = exports.hasDataRoutes = {
  ...hasDataRoute
};