"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHasData = getHasData;
var _esql_result_to_plain_objects = require("@kbn/observability-utils/es/utils/esql_result_to_plain_objects");
var _query_helper = require("../entities/query_helper");
var _entities = require("../../../common/entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHasData({
  inventoryEsClient,
  logger
}) {
  try {
    var _esqlResultToPlainObj, _esqlResultToPlainObj2;
    const esqlResults = await inventoryEsClient.esql('get_has_data', {
      query: `FROM ${_entities.ENTITIES_LATEST_ALIAS} 
      | ${(0, _query_helper.getEntityDefinitionIdWhereClause)()} 
      | ${(0, _query_helper.getEntityTypesWhereClause)()} 
      | STATS _count = COUNT(*)
      | LIMIT 1`
    });
    const totalCount = (_esqlResultToPlainObj = (_esqlResultToPlainObj2 = (0, _esql_result_to_plain_objects.esqlResultToPlainObjects)(esqlResults)) === null || _esqlResultToPlainObj2 === void 0 ? void 0 : _esqlResultToPlainObj2[0]._count) !== null && _esqlResultToPlainObj !== void 0 ? _esqlResultToPlainObj : 0;
    return {
      hasData: totalCount > 0
    };
  } catch (e) {
    logger.error(e);
    return {
      hasData: false
    };
  }
}