"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listLatestEntitiesRoute = exports.getEntityTypesRoute = exports.entitiesRoutes = void 0;
var _constants = require("@kbn/deeplinks-observability/constants");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _create_observability_es_client = require("@kbn/observability-utils/es/client/create_observability_es_client");
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _join_by_key = require("@kbn/observability-utils/array/join_by_key");
var _entities = require("../../../common/entities");
var _create_inventory_server_route = require("../create_inventory_server_route");
var _get_entity_types = require("./get_entity_types");
var _get_latest_entities = require("./get_latest_entities");
var _create_alerts_client = require("../../lib/create_alerts_client.ts/create_alerts_client");
var _get_latest_entities_alerts = require("./get_latest_entities_alerts");
var _get_identity_fields_per_entity_type = require("./get_identity_fields_per_entity_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityTypesRoute = exports.getEntityTypesRoute = (0, _create_inventory_server_route.createInventoryServerRoute)({
  endpoint: 'GET /internal/inventory/entities/types',
  options: {
    tags: ['access:inventory']
  },
  handler: async ({
    context,
    logger
  }) => {
    const coreContext = await context.core;
    const inventoryEsClient = (0, _create_observability_es_client.createObservabilityEsClient)({
      client: coreContext.elasticsearch.client.asCurrentUser,
      logger,
      plugin: `@kbn/${_constants.INVENTORY_APP_ID}-plugin`
    });
    const entityTypes = await (0, _get_entity_types.getEntityTypes)({
      inventoryEsClient
    });
    return {
      entityTypes
    };
  }
});
const listLatestEntitiesRoute = exports.listLatestEntitiesRoute = (0, _create_inventory_server_route.createInventoryServerRoute)({
  endpoint: 'GET /internal/inventory/entities',
  params: t.type({
    query: t.intersection([t.type({
      sortField: _entities.entityColumnIdsRt,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')])
    }), t.partial({
      entityTypes: _ioTsUtils.jsonRt.pipe(t.array(_entities.entityTypeRt)),
      kuery: t.string
    })])
  }),
  options: {
    tags: ['access:inventory']
  },
  handler: async ({
    params,
    context,
    logger,
    plugins,
    request
  }) => {
    const coreContext = await context.core;
    const inventoryEsClient = (0, _create_observability_es_client.createObservabilityEsClient)({
      client: coreContext.elasticsearch.client.asCurrentUser,
      logger,
      plugin: `@kbn/${_constants.INVENTORY_APP_ID}-plugin`
    });
    const {
      sortDirection,
      sortField,
      entityTypes,
      kuery
    } = params.query;
    const [alertsClient, latestEntities] = await Promise.all([(0, _create_alerts_client.createAlertsClient)({
      plugins,
      request
    }), (0, _get_latest_entities.getLatestEntities)({
      inventoryEsClient,
      sortDirection,
      sortField,
      entityTypes,
      kuery
    })]);
    const identityFieldsPerEntityType = (0, _get_identity_fields_per_entity_type.getIdentityFieldsPerEntityType)(latestEntities);
    const alerts = await (0, _get_latest_entities_alerts.getLatestEntitiesAlerts)({
      identityFieldsPerEntityType,
      alertsClient,
      kuery
    });
    const joined = (0, _join_by_key.joinByKey)([...latestEntities, ...alerts], [...identityFieldsPerEntityType.values()].flat()).filter(entity => entity['entity.id']);
    return {
      entities: sortField === 'alertsCount' ? (0, _lodash.orderBy)(joined, [item => (item === null || item === void 0 ? void 0 : item.alertsCount) === undefined, sortField], ['asc', sortDirection] // push entities without alertsCount to the end
      ) : joined
    };
  }
});
const entitiesRoutes = exports.entitiesRoutes = {
  ...listLatestEntitiesRoute,
  ...getEntityTypesRoute
};