"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityTypesWhereClause = exports.getEntityDefinitionIdWhereClause = void 0;
var _common = require("@kbn/observability-shared-plugin/common");
var _entities = require("../../../common/entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityTypesWhereClause = (entityTypes = _entities.defaultEntityTypes) => `WHERE ${_common.ENTITY_TYPE} IN (${entityTypes.map(entityType => `"${entityType}"`).join()})`;
exports.getEntityTypesWhereClause = getEntityTypesWhereClause;
const getEntityDefinitionIdWhereClause = () => `WHERE ${_common.ENTITY_DEFINITION_ID} IN (${[..._entities.defaultEntityDefinitions].map(buildin => `"${buildin}"`).join()})`;
exports.getEntityDefinitionIdWhereClause = getEntityDefinitionIdWhereClause;