"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestEntities = getLatestEntities;
var _kql_query = require("@kbn/observability-utils/es/queries/kql_query");
var _esql_result_to_plain_objects = require("@kbn/observability-utils/es/utils/esql_result_to_plain_objects");
var _common = require("@kbn/observability-shared-plugin/common");
var _entities = require("../../../common/entities");
var _query_helper = require("./query_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLatestEntities({
  inventoryEsClient,
  sortDirection,
  sortField,
  entityTypes,
  kuery
}) {
  // alertsCount doesn't exist in entities index. Ignore it and sort by entity.lastSeenTimestamp by default.
  const entitiesSortField = sortField === 'alertsCount' ? _common.ENTITY_LAST_SEEN : sortField;
  const request = {
    query: `FROM ${_entities.ENTITIES_LATEST_ALIAS}
     | ${(0, _query_helper.getEntityTypesWhereClause)(entityTypes)}
     | ${(0, _query_helper.getEntityDefinitionIdWhereClause)()}
     | SORT ${entitiesSortField} ${sortDirection}
     | LIMIT ${_entities.MAX_NUMBER_OF_ENTITIES}
     `,
    filter: {
      bool: {
        filter: [...(0, _kql_query.kqlQuery)(kuery)]
      }
    }
  };
  const latestEntitiesEsqlResponse = await inventoryEsClient.esql('get_latest_entities', request);
  return (0, _esql_result_to_plain_objects.esqlResultToPlainObjects)(latestEntitiesEsqlResponse);
}