"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIdentityFieldsPerEntityType = void 0;
var _common = require("@kbn/observability-shared-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIdentityFieldsPerEntityType = entities => {
  const identityFieldsPerEntityType = new Map();
  entities.forEach(entity => identityFieldsPerEntityType.set(entity[_common.ENTITY_TYPE], [entity[_common.ENTITY_IDENTITY_FIELDS]].flat()));
  return identityFieldsPerEntityType;
};
exports.getIdentityFieldsPerEntityType = getIdentityFieldsPerEntityType;