"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupByTermsAgg = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGroupByTermsAgg = (fields, maxSize = 500) => {
  return Array.from(fields).reduce((acc, [entityType, identityFields]) => {
    acc[entityType] = {
      composite: {
        size: maxSize,
        sources: identityFields.map(field => ({
          [field]: {
            terms: {
              field
            }
          }
        }))
      }
    };
    return acc;
  }, {});
};
exports.getGroupByTermsAgg = getGroupByTermsAgg;