"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityTypes = getEntityTypes;
var _common = require("@kbn/observability-shared-plugin/common");
var _entities = require("../../../common/entities");
var _query_helper = require("./query_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getEntityTypes({
  inventoryEsClient
}) {
  const entityTypesEsqlResponse = await inventoryEsClient.esql('get_entity_types', {
    query: `FROM ${_entities.ENTITIES_LATEST_ALIAS}
     | ${(0, _query_helper.getEntityTypesWhereClause)()}
     | ${(0, _query_helper.getEntityDefinitionIdWhereClause)()}
     | STATS count = COUNT(${_common.ENTITY_TYPE}) BY ${_common.ENTITY_TYPE}
    `
  });
  return entityTypesEsqlResponse.values.map(([_, val]) => val);
}