"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _register_routes = require("./routes/register_routes");
var _feature = require("./feature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InventoryPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(coreSetup, pluginsSetup) {
    const startServicesPromise = coreSetup.getStartServices().then(([_coreStart, pluginsStart]) => pluginsStart);
    (0, _register_routes.registerServerRoutes)({
      core: coreSetup,
      logger: this.logger,
      dependencies: {
        plugins: (0, _lodash.mapValues)(pluginsSetup, (value, key) => {
          return {
            start: () => startServicesPromise.then(startServices => startServices[key]),
            setup: () => value
          };
        })
      }
    });
    pluginsSetup.features.registerKibanaFeature(_feature.INVENTORY_SERVER_FEATURE);
    return {};
  }
  start(core, pluginsStart) {
    return {};
  }
}
exports.InventoryPlugin = InventoryPlugin;