"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAlertsClient = createAlertsClient;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createAlertsClient({
  plugins,
  request
}) {
  const ruleRegistryPluginStart = await plugins.ruleRegistry.start();
  const alertsClient = await ruleRegistryPluginStart.getRacClientWithRequest(request);
  const alertsIndices = await alertsClient.getAuthorizedAlertsIndices(['logs', 'infrastructure', 'apm', 'slo', 'observability']);
  if (!alertsIndices || (0, _lodash.isEmpty)(alertsIndices)) {
    throw Error('No alert indices exist');
  }
  return {
    search(searchParams) {
      return alertsClient.find({
        ...searchParams,
        index: alertsIndices.join(',')
      });
    }
  };
}