"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityTypeLabel = getEntityTypeLabel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEntityTypeLabel(entityType) {
  switch (entityType) {
    case 'service':
      return _i18n.i18n.translate('xpack.inventory.entityType.serviceLabel', {
        defaultMessage: 'Service'
      });
    case 'container':
      return _i18n.i18n.translate('xpack.inventory.entityType.containerLabel', {
        defaultMessage: 'Container'
      });
    case 'host':
      return _i18n.i18n.translate('xpack.inventory.entityType.hostLabel', {
        defaultMessage: 'Host'
      });
    default:
      return _i18n.i18n.translate('xpack.inventory.entityType.naLabel', {
        defaultMessage: 'N/A'
      });
  }
}