"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "reportInventoryAddData", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.INVENTORY_ADD_DATA_CLICKED, params);
    });
    (0, _defineProperty2.default)(this, "reportEntityInventoryViewed", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.ENTITY_INVENTORY_VIEWED, params);
    });
    (0, _defineProperty2.default)(this, "reportEntityInventorySearchQuerySubmitted", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.ENTITY_INVENTORY_SEARCH_QUERY_SUBMITTED, params);
    });
    (0, _defineProperty2.default)(this, "reportEntityInventoryEntityTypeFiltered", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.ENTITY_INVENTORY_ENTITY_TYPE_FILTERED, params);
    });
    (0, _defineProperty2.default)(this, "reportEntityViewClicked", params => {
      this.analytics.reportEvent(_types.TelemetryEventTypes.ENTITY_VIEW_CLICKED, params);
    });
    this.analytics = analytics;
  }
}
exports.TelemetryClient = TelemetryClient;