"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inventoryRouter = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _inventory_page_template = require("../components/inventory_page_template");
var _inventory_page = require("../pages/inventory_page");
var _entities = require("../../common/entities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The array of route definitions to be used when the application
 * creates the routes.
 */
const inventoryRoutes = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_inventory_page_template.InventoryPageTemplate, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    params: t.type({
      query: t.intersection([t.type({
        sortField: _entities.entityColumnIdsRt,
        sortDirection: t.union([t.literal('asc'), t.literal('desc')]),
        pageIndex: _ioTsUtils.toNumberRt
      }), t.partial({
        entityTypes: _entities.entityTypesRt,
        kuery: t.string
      })])
    }),
    defaults: {
      query: {
        sortField: _entities.defaultEntitySortField,
        sortDirection: 'desc',
        pageIndex: '0'
      }
    },
    children: {
      '/{type}': {
        element: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
        params: t.type({
          path: t.type({
            type: t.string
          })
        })
      },
      '/': {
        element: /*#__PURE__*/_react.default.createElement(_inventory_page.InventoryPage, null)
      }
    }
  }
};
const inventoryRouter = exports.inventoryRouter = (0, _typedReactRouterConfig.createRouter)(inventoryRoutes);