"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _constants = require("@kbn/deeplinks-observability/constants");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _api = require("./api");
var _telemetry_service = require("./services/telemetry/telemetry_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class InventoryPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "isServerlessEnv", void 0);
    this.logger = context.logger.get();
    this.telemetry = new _telemetry_service.TelemetryService();
    this.kibanaVersion = context.env.packageInfo.version;
    this.isServerlessEnv = context.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(coreSetup, pluginsSetup) {
    var _pluginsSetup$cloud, _pluginsSetup$cloud2;
    const inventoryAPIClient = (0, _api.createCallInventoryAPI)(coreSetup);
    const isEntityCentricExperienceSettingEnabled = coreSetup.uiSettings.get('observability:entityCentricExperience', true);
    this.telemetry.setup({
      analytics: coreSetup.analytics
    });
    const telemetry = this.telemetry.start();
    const getStartServices = coreSetup.getStartServices();
    const hideInventory$ = (0, _rxjs.from)(getStartServices).pipe((0, _rxjs.mergeMap)(([coreStart, pluginsStart]) => {
      if (pluginsStart.spaces) {
        return (0, _rxjs.from)(pluginsStart.spaces.getActiveSpace()).pipe((0, _rxjs.map)(space => space.disabledFeatures.includes(_constants.INVENTORY_APP_ID) || !coreStart.application.capabilities.inventory.show));
      }
      return (0, _rxjs.of)(!coreStart.application.capabilities.inventory.show);
    }));
    const sections$ = hideInventory$.pipe((0, _rxjs.map)(hideInventory => {
      if (isEntityCentricExperienceSettingEnabled && !hideInventory) {
        return [{
          label: '',
          sortKey: 300,
          entries: [{
            label: _i18n.i18n.translate('xpack.inventory.inventoryLinkTitle', {
              defaultMessage: 'Inventory'
            }),
            app: _constants.INVENTORY_APP_ID,
            path: '/',
            matchPath(currentPath) {
              return ['/', ''].some(testPath => currentPath.startsWith(testPath));
            },
            isTechnicalPreview: true
          }]
        }];
      }
      return [];
    }));
    pluginsSetup.observabilityShared.navigation.registerSections(sections$);
    const isCloudEnv = !!((_pluginsSetup$cloud = pluginsSetup.cloud) !== null && _pluginsSetup$cloud !== void 0 && _pluginsSetup$cloud.isCloudEnabled);
    const isServerlessEnv = ((_pluginsSetup$cloud2 = pluginsSetup.cloud) === null || _pluginsSetup$cloud2 === void 0 ? void 0 : _pluginsSetup$cloud2.isServerlessEnabled) || this.isServerlessEnv;
    coreSetup.application.register({
      id: _constants.INVENTORY_APP_ID,
      title: _i18n.i18n.translate('xpack.inventory.appTitle', {
        defaultMessage: 'Inventory'
      }),
      euiIconType: 'logoObservability',
      appRoute: '/app/inventory',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      visibleIn: ['sideNav', 'globalSearch'],
      order: 8200,
      status: isEntityCentricExperienceSettingEnabled ? _public.AppStatus.accessible : _public.AppStatus.inaccessible,
      mount: async appMountParameters => {
        // Load application bundle and Get start services
        const [{
          renderApp
        }, [coreStart, pluginsStart]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), getStartServices]);
        const services = {
          inventoryAPIClient,
          telemetry
        };
        return renderApp({
          coreStart,
          pluginsStart,
          services,
          appMountParameters,
          kibanaEnvironment: {
            isCloudEnv,
            isServerlessEnv,
            kibanaVersion: this.kibanaVersion
          }
        });
      }
    });
    return {};
  }
  start(coreStart, pluginsStart) {
    return {};
  }
}
exports.InventoryPlugin = InventoryPlugin;