"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryPage = InventoryPage;
var _react = _interopRequireDefault(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _entities_grid = require("../../components/entities_grid");
var _inventory_search_bar_context_provider = require("../../context/inventory_search_bar_context_provider");
var _use_inventory_abortable_async = require("../../hooks/use_inventory_abortable_async");
var _use_inventory_params = require("../../hooks/use_inventory_params");
var _use_inventory_router = require("../../hooks/use_inventory_router");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InventoryPage() {
  const {
    searchBarContentSubject$
  } = (0, _inventory_search_bar_context_provider.useInventorySearchBarContext)();
  const {
    services: {
      inventoryAPIClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    query
  } = (0, _use_inventory_params.useInventoryParams)('/');
  const {
    sortDirection,
    sortField,
    pageIndex,
    kuery,
    entityTypes
  } = query;
  const inventoryRoute = (0, _use_inventory_router.useInventoryRouter)();
  const {
    value = {
      entities: []
    },
    loading,
    refresh
  } = (0, _use_inventory_abortable_async.useInventoryAbortableAsync)(({
    signal
  }) => {
    return inventoryAPIClient.fetch('GET /internal/inventory/entities', {
      params: {
        query: {
          sortDirection,
          sortField,
          entityTypes: entityTypes !== null && entityTypes !== void 0 && entityTypes.length ? JSON.stringify(entityTypes) : undefined,
          kuery
        }
      },
      signal
    });
  }, [entityTypes, inventoryAPIClient, kuery, sortDirection, sortField]);
  (0, _useEffectOnce.default)(() => {
    const searchBarContentSubscription = searchBarContentSubject$.subscribe(({
      refresh: isRefresh,
      ...queryParams
    }) => {
      if (isRefresh) {
        refresh();
      } else {
        inventoryRoute.push('/', {
          path: {},
          query: {
            ...query,
            ...queryParams
          }
        });
      }
    });
    return () => {
      searchBarContentSubscription.unsubscribe();
    };
  });
  function handlePageChange(nextPage) {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        pageIndex: nextPage
      }
    });
  }
  function handleSortChange(sorting) {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        sortField: sorting.id,
        sortDirection: sorting.direction
      }
    });
  }
  function handleTypeFilter(entityType) {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        // Override the current entity types
        entityTypes: [entityType]
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_entities_grid.EntitiesGrid, {
    entities: value.entities,
    loading: loading,
    sortDirection: sortDirection,
    sortField: sortField,
    onChangePage: handlePageChange,
    onChangeSort: handleSortChange,
    pageIndex: pageIndex,
    onFilterByType: handleTypeFilter
  });
}