"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInventoryRouter = useInventoryRouter;
var _react = require("react");
var _config = require("../routes/config");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useInventoryRouter() {
  const {
    services: {
      http,
      application: {
        navigateToApp
      }
    }
  } = (0, _use_kibana.useKibana)();
  const link = (...args) => {
    // @ts-expect-error
    return _config.inventoryRouter.link(...args);
  };
  return (0, _react.useMemo)(() => ({
    ..._config.inventoryRouter,
    push: (...args) => {
      const next = link(...args);
      navigateToApp('inventory', {
        path: next,
        replace: false
      });
    },
    replace: (path, ...args) => {
      const next = link(path, ...args);
      navigateToApp('inventory', {
        path: next,
        replace: true
      });
    },
    link: (path, ...args) => {
      return http.basePath.prepend('/app/observability/inventory' + link(path, ...args));
    }
  }), [navigateToApp, http.basePath]);
}