"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInventoryAbortableAsync = useInventoryAbortableAsync;
var _use_abortable_async = require("@kbn/observability-utils/hooks/use_abortable_async");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDetailsFromErrorResponse = error => {
  var _error$body$message, _error$body, _error$response;
  return (_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.statusText;
};
function useInventoryAbortableAsync(...args) {
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const response = (0, _use_abortable_async.useAbortableAsync)(...args);
  if (response.error) {
    const errorMessage = 'response' in response.error ? getDetailsFromErrorResponse(response.error) : response.error.message;
    notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.inventory.apiCall.error.title', {
        defaultMessage: `Error while fetching resource`
      }),
      text: errorMessage
    });
  }
  return response;
}