"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityManager = void 0;
var _use_abortable_async = require("@kbn/observability-utils/hooks/use_abortable_async");
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEntityManager = () => {
  const {
    services: {
      entityManager
    }
  } = (0, _use_kibana.useKibana)();
  const [showWelcomedModal, setWelcomedModal] = (0, _react.useState)(false);
  const {
    value = {
      enabled: false
    },
    loading,
    refresh
  } = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    return entityManager.entityClient.isManagedEntityDiscoveryEnabled();
  }, [entityManager]);
  return {
    isEntityManagerEnabled: value.enabled,
    isEnablementLoading: loading,
    refresh,
    showWelcomedModal,
    toggleWelcomedModal: () => setWelcomedModal(state => !state)
  };
};
exports.useEntityManager = useEntityManager;