"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ASSOCIATE_LOGS_LINK = void 0;
exports.AddData = AddData;
exports.AssociateServiceLogs = AssociateServiceLogs;
exports.associateServiceLogsItem = exports.addDataTitle = exports.addDataItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Disabling it for now until the EUI team fixes it

/* eslint-disable @elastic/eui/href-or-on-click */

const addDataTitle = exports.addDataTitle = _i18n.i18n.translate('xpack.inventory.addDataContextMenu.link', {
  defaultMessage: 'Add data'
});
const addDataItem = exports.addDataItem = _i18n.i18n.translate('xpack.inventory.add.apm.agent.button.', {
  defaultMessage: 'Add data'
});
const associateServiceLogsItem = exports.associateServiceLogsItem = _i18n.i18n.translate('xpack.inventory.associate.service.logs.button', {
  defaultMessage: 'Associate existing service logs'
});
const ASSOCIATE_LOGS_LINK = exports.ASSOCIATE_LOGS_LINK = 'https://ela.st/new-experience-associate-service-logs';
function AssociateServiceLogs({
  onClick
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "associateServiceLogsButton",
    size: "s",
    onClick: onClick,
    href: ASSOCIATE_LOGS_LINK,
    target: "_blank",
    iconType: "popout",
    iconSide: "right"
  }, associateServiceLogsItem);
}
function AddData({
  onClick
}) {
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibana)();
  const onboardingLocator = share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    "data-test-subj": "addDataButton",
    size: "s",
    onClick: onClick,
    color: "primary",
    fill: true,
    href: onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.getRedirectUrl({
      category: ''
    })
  }, addDataItem);
}