"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = SearchBar;
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _inventory_search_bar_context_provider = require("../../context/inventory_search_bar_context_provider");
var _use_adhoc_inventory_data_view = require("../../hooks/use_adhoc_inventory_data_view");
var _use_inventory_params = require("../../hooks/use_inventory_params");
var _use_kibana = require("../../hooks/use_kibana");
var _entity_types_controls = require("./entity_types_controls");
var _discover_button = require("./discover_button");
var _get_kql_field_names_with_fallback = require("../../utils/get_kql_field_names_with_fallback");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SearchBar() {
  const {
    searchBarContentSubject$
  } = (0, _inventory_search_bar_context_provider.useInventorySearchBarContext)();
  const {
    services: {
      unifiedSearch,
      data: {
        query: {
          queryString: queryStringService
        }
      },
      telemetry
    }
  } = (0, _use_kibana.useKibana)();
  const {
    query: {
      kuery,
      entityTypes
    }
  } = (0, _use_inventory_params.useInventoryParams)('/*');
  const {
    SearchBar: UnifiedSearchBar
  } = unifiedSearch.ui;
  const {
    dataView
  } = (0, _use_adhoc_inventory_data_view.useAdHocInventoryDataView)();
  const syncSearchBarWithUrl = (0, _react.useCallback)(() => {
    const query = kuery ? {
      query: kuery,
      language: 'kuery'
    } : undefined;
    if (query && !(0, _fastDeepEqual.default)(queryStringService.getQuery(), query)) {
      queryStringService.setQuery(query);
    }
    if (!query) {
      queryStringService.clearQuery();
    }
  }, [kuery, queryStringService]);
  (0, _react.useEffect)(() => {
    syncSearchBarWithUrl();
  }, [syncSearchBarWithUrl]);
  const registerSearchSubmittedEvent = (0, _react.useCallback)(({
    searchQuery,
    searchIsUpdate,
    searchEntityTypes
  }) => {
    telemetry.reportEntityInventorySearchQuerySubmitted({
      kuery_fields: (0, _get_kql_field_names_with_fallback.getKqlFieldsWithFallback)(searchQuery === null || searchQuery === void 0 ? void 0 : searchQuery.query),
      entity_types: searchEntityTypes || [],
      action: searchIsUpdate ? 'submit' : 'refresh'
    });
  }, [telemetry]);
  const registerEntityTypeFilteredEvent = (0, _react.useCallback)(({
    filterEntityTypes,
    filterKuery
  }) => {
    telemetry.reportEntityInventoryEntityTypeFiltered({
      entity_types: filterEntityTypes,
      kuery_fields: filterKuery ? (0, _get_kql_field_names_with_fallback.getKqlFieldsWithFallback)(filterKuery) : []
    });
  }, [telemetry]);
  const handleEntityTypesChange = (0, _react.useCallback)(nextEntityTypes => {
    searchBarContentSubject$.next({
      kuery,
      entityTypes: nextEntityTypes,
      refresh: false
    });
    registerEntityTypeFilteredEvent({
      filterEntityTypes: nextEntityTypes,
      filterKuery: kuery
    });
  }, [kuery, registerEntityTypeFilteredEvent, searchBarContentSubject$]);
  const handleQuerySubmit = (0, _react.useCallback)(({
    query
  }, isUpdate) => {
    searchBarContentSubject$.next({
      kuery: query === null || query === void 0 ? void 0 : query.query,
      entityTypes,
      refresh: !isUpdate
    });
    registerSearchSubmittedEvent({
      searchQuery: query,
      searchEntityTypes: entityTypes,
      searchIsUpdate: isUpdate
    });
  }, [entityTypes, registerSearchSubmittedEvent, searchBarContentSubject$]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(UnifiedSearchBar, {
    appName: "Inventory",
    displayStyle: "inPage",
    showDatePicker: false,
    showFilterBar: false,
    indexPatterns: dataView ? [dataView] : undefined,
    renderQueryInputAppend: () => /*#__PURE__*/_react.default.createElement(_entity_types_controls.EntityTypesControls, {
      onChange: handleEntityTypesChange
    }),
    onQuerySubmit: handleQuerySubmit,
    placeholder: _i18n.i18n.translate('xpack.inventory.searchBar.placeholder', {
      defaultMessage: 'Search for your entities by name or its metadata (e.g. entity.type : service)'
    })
  })), dataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_discover_button.DiscoverButton, {
    dataView: dataView
  })) : null);
}