"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityTypesControls = EntityTypesControls;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _use_inventory_abortable_async = require("../../hooks/use_inventory_abortable_async");
var _use_inventory_params = require("../../hooks/use_inventory_params");
var _use_kibana = require("../../hooks/use_kibana");
var _get_entity_type_label = require("../../utils/get_entity_type_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toComboBoxOption = entityType => ({
  key: entityType,
  label: (0, _get_entity_type_label.getEntityTypeLabel)(entityType)
});
function EntityTypesControls({
  onChange
}) {
  const {
    query: {
      entityTypes = []
    }
  } = (0, _use_inventory_params.useInventoryParams)('/*');
  const {
    services: {
      inventoryAPIClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value,
    loading
  } = (0, _use_inventory_abortable_async.useInventoryAbortableAsync)(({
    signal
  }) => {
    return inventoryAPIClient.fetch('GET /internal/inventory/entities/types', {
      signal
    });
  }, [inventoryAPIClient]);
  const options = value === null || value === void 0 ? void 0 : value.entityTypes.map(toComboBoxOption);
  const selectedOptions = entityTypes.map(toComboBoxOption);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
    isLoading: loading,
    css: (0, _react.css)`
        max-width: 325px;
      `,
    "aria-label": _i18n.i18n.translate('xpack.inventory.entityTypesControls.euiComboBox.accessibleScreenReaderLabel', {
      defaultMessage: 'Entity types filter'
    }),
    placeholder: _i18n.i18n.translate('xpack.inventory.entityTypesControls.euiComboBox.placeHolderLabel', {
      defaultMessage: 'Types'
    }),
    options: options,
    selectedOptions: selectedOptions,
    onChange: newOptions => {
      onChange(newOptions.map(option => option.key));
    },
    isClearable: true
  });
}