"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverButton = DiscoverButton;
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-shared-plugin/common");
var _entities = require("../../../common/entities");
var _use_inventory_params = require("../../hooks/use_inventory_params");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTIVE_COLUMNS = [_common.ENTITY_DISPLAY_NAME, _common.ENTITY_TYPE, _common.ENTITY_LAST_SEEN];
function DiscoverButton({
  dataView
}) {
  var _dataView$id, _application$capabili;
  const {
    services: {
      share,
      application
    }
  } = (0, _use_kibana.useKibana)();
  const {
    query: {
      kuery,
      entityTypes
    }
  } = (0, _use_inventory_params.useInventoryParams)('/*');
  const discoverLocator = (0, _react.useMemo)(() => share.url.locators.get('DISCOVER_APP_LOCATOR'), [share.url.locators]);
  const filters = [];
  const entityDefinitionField = dataView.getFieldByName(_common.ENTITY_DEFINITION_ID);
  if (entityDefinitionField) {
    const entityDefinitionFilter = (0, _esQuery.buildPhrasesFilter)(entityDefinitionField, _entities.defaultEntityDefinitions, dataView);
    filters.push(entityDefinitionFilter);
  }
  const entityTypeField = dataView.getFieldByName(_common.ENTITY_TYPE);
  if (entityTypes && entityTypeField) {
    const entityTypeFilter = (0, _esQuery.buildPhrasesFilter)(entityTypeField, entityTypes, dataView);
    filters.push(entityTypeFilter);
  }
  const discoverLink = discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.getRedirectUrl({
    indexPatternId: (_dataView$id = dataView === null || dataView === void 0 ? void 0 : dataView.id) !== null && _dataView$id !== void 0 ? _dataView$id : '',
    columns: ACTIVE_COLUMNS,
    query: {
      query: kuery !== null && kuery !== void 0 ? kuery : '',
      language: 'kuery'
    },
    filters
  });
  if (!((_application$capabili = application.capabilities.discover) !== null && _application$capabili !== void 0 && _application$capabili.show) || !discoverLink) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    iconType: "discoverApp",
    href: discoverLink,
    "data-test-subj": "inventorySearchBarDiscoverButton"
  }, _i18n.i18n.translate('xpack.inventory.searchBar.discoverButton', {
    defaultMessage: 'Open in discover'
  }));
}