"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityManagerEnablement = getEntityManagerEnablement;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _enable_entity_model_button = require("../entity_enablement/enable_entity_model_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEntityManagerEnablement({
  enabled,
  loading,
  onSuccess
}) {
  if (enabled || loading) {
    return;
  }
  return {
    solution: _i18n.i18n.translate('xpack.inventory.noData.solutionName', {
      defaultMessage: 'Observability'
    }),
    action: {
      elasticAgent: {
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.inventory.noData.card.description",
          defaultMessage: "The {inventoryLink} uses the {link} to show all of your observed entities in one place.",
          values: {
            inventoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              "data-test-subj": "inventoryNoDataCardInventoryLink",
              href: "https://ela.st/docs-entity-inventory",
              external: true,
              target: "_blank"
            }, _i18n.i18n.translate('xpack.inventory.noData.card.description.inventory', {
              defaultMessage: 'Inventory'
            })),
            link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              "data-test-subj": "inventoryNoDataCardLink",
              href: "https://ela.st/docs-elastic-entity-model",
              external: true,
              target: "_blank"
            }, _i18n.i18n.translate('xpack.inventory.noData.card.description.link', {
              defaultMessage: 'Elastic Entity Model'
            }))
          }
        }),
        button: /*#__PURE__*/_react.default.createElement(_enable_entity_model_button.EnableEntityModelButton, {
          onSuccess: onSuccess
        }),
        onClick: event => {
          event.preventDefault();
        }
      }
    },
    pageTitle: _i18n.i18n.translate('xpack.inventory.noData.page.title', {
      defaultMessage: 'See everything you have in one place!'
    }),
    pageDescription: _i18n.i18n.translate('xpack.inventory.noData.page.description', {
      defaultMessage: 'The inventory will show all of your observed entities in one place so you can detect and resolve problems with them faster!'
    })
  };
}