"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityIcon = EntityIcon;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-shared-plugin/common");
var _customIcons = require("@kbn/custom-icons");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSingleValue = value => {
  return value == null ? undefined : Array.isArray(value) ? value[0] : value;
};
function EntityIcon({
  entity
}) {
  const entityType = entity[_common.ENTITY_TYPE];
  const defaultIconSize = _uiTheme.euiThemeVars.euiSizeL;
  switch (entityType) {
    case 'host':
    case 'container':
      {
        const cloudProvider = getSingleValue(entity[_common.CLOUD_PROVIDER]);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          style: {
            width: defaultIconSize,
            height: defaultIconSize
          },
          alignItems: "center",
          justifyContent: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
          cloudProvider: cloudProvider,
          size: "m",
          title: cloudProvider,
          role: "presentation"
        })));
      }
    case 'service':
      {
        const agentName = getSingleValue(entity[_common.AGENT_NAME]);
        return /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
          agentName: agentName,
          role: "presentation"
        });
      }
    default:
      // Return an empty EuiIcon instead of null to maintain UI alignment across all EntityIcon usages
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "",
        size: "l"
      });
  }
}