"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Unauthorized = Unauthorized;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _entities_inventory_light = _interopRequireDefault(require("../../assets/entities_inventory_light.png"));
var _entities_inventory_dark = _interopRequireDefault(require("../../assets/entities_inventory_dark.png"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Unauthorized({
  onClose
}) {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    style: {
      width: '630px'
    },
    onCancel: onClose,
    onConfirm: onClose,
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "xpack.inventory.unauthorised.button",
      fill: true,
      size: "s"
    }, _i18n.i18n.translate('xpack.inventory.unauthorised.button', {
      defaultMessage: 'OK'
    })),
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      "data-test-subj": "inventoryUnauthorizedLinkExternal",
      href: "https://ela.st/docs-entity-inventory",
      external: true
    }, _i18n.i18n.translate('xpack.inventory.unauthorized.linkLabel', {
      defaultMessage: 'Learn more'
    })),
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "lock",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.inventory.unauthorised.title', {
    defaultMessage: 'Insufficient permissions'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.inventory.unauthorised.body', {
    defaultMessage: "You don't have permissions to turn on the Elastic Entity Model. Please ask your administrator to enable this for you so you can see everything you have in one place."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    allowFullScreen: true,
    size: "xl",
    src: colorMode === _eui.COLOR_MODES_STANDARD.dark ? _entities_inventory_dark.default : _entities_inventory_light.default,
    alt: _i18n.i18n.translate('xpack.inventory.unauthorised.image.at,', {
      defaultMessage: 'Image of the new experience of the entities inventory, showing services, hosts and containers'
    })
  })));
}