"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableEntityModelButton = EnableEntityModelButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/entityManager-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../hooks/use_kibana");
var _unauthorized_modal = require("./unauthorized_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EnableEntityModelButton({
  onSuccess
}) {
  const {
    services: {
      entityManager,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [showModal, setModalVisible] = (0, _react.useState)(false);
  const handleEnablement = async () => {
    setIsLoading(true);
    try {
      const response = await entityManager.entityClient.enableManagedEntityDiscovery();
      if (response.success) {
        setIsLoading(false);
        onSuccess();
      } else {
        throw new Error(response.message);
      }
    } catch (error) {
      var _err$body$message, _err$body, _err$response;
      setIsLoading(false);
      if (error instanceof _public.EntityManagerUnauthorizedError) {
        setModalVisible(true);
        return;
      }
      const err = error;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.inventory.eemEnablement.errorTitle', {
          defaultMessage: 'Error while enabling the new entity model'
        }),
        text: 'response' in err ? (_err$body$message = (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message) !== null && _err$body$message !== void 0 ? _err$body$message : (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.statusText : err.message
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    "data-test-subj": "inventoryInventoryPageTemplateFilledButton",
    fill: true,
    onClick: handleEnablement,
    iconType: () => /*#__PURE__*/_react.default.createElement(_public2.TechnicalPreviewBadge, null),
    iconSide: "right"
  }, _i18n.i18n.translate('xpack.inventory.noData.card.button', {
    defaultMessage: 'Enable'
  })), showModal ? /*#__PURE__*/_react.default.createElement(_unauthorized_modal.Unauthorized, {
    onClose: () => setModalVisible(false)
  }) : null);
}