"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntitiesGrid = EntitiesGrid;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-shared-plugin/common");
var _badge_filter_with_popover = require("../badge_filter_with_popover");
var _grid_columns = require("./grid_columns");
var _alerts_badge = require("../alerts_badge/alerts_badge");
var _entity_name = require("./entity_name");
var _get_entity_type_label = require("../../utils/get_entity_type_label");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE = 20;
function EntitiesGrid({
  entities,
  loading,
  sortDirection,
  sortField,
  pageIndex,
  onChangePage,
  onChangeSort,
  onFilterByType
}) {
  const onSort = (0, _react.useCallback)(newSortingColumns => {
    const lastItem = (0, _lodash.last)(newSortingColumns);
    if (lastItem) {
      onChangeSort(lastItem);
    }
  }, [onChangeSort]);
  const showAlertsColumn = (0, _react.useMemo)(() => entities === null || entities === void 0 ? void 0 : entities.some(entity => (entity === null || entity === void 0 ? void 0 : entity.alertsCount) && (entity === null || entity === void 0 ? void 0 : entity.alertsCount) > 0), [entities]);
  const columnVisibility = (0, _react.useMemo)(() => ({
    visibleColumns: (0, _grid_columns.getColumns)({
      showAlertsColumn
    }).map(({
      id
    }) => id),
    setVisibleColumns: () => {}
  }), [showAlertsColumn]);
  const renderCellValue = (0, _react.useCallback)(({
    rowIndex,
    columnId
  }) => {
    const entity = entities[rowIndex];
    if (entity === undefined) {
      return null;
    }
    const columnEntityTableId = columnId;
    const entityType = entity[_common.ENTITY_TYPE];
    switch (columnEntityTableId) {
      case 'alertsCount':
        return entity !== null && entity !== void 0 && entity.alertsCount ? /*#__PURE__*/_react.default.createElement(_alerts_badge.AlertsBadge, {
          entity: entity
        }) : null;
      case _common.ENTITY_TYPE:
        return /*#__PURE__*/_react.default.createElement(_badge_filter_with_popover.BadgeFilterWithPopover, {
          field: _common.ENTITY_TYPE,
          value: entityType,
          label: (0, _get_entity_type_label.getEntityTypeLabel)(entityType),
          onFilter: () => onFilterByType(entityType)
        });
      case _common.ENTITY_LAST_SEEN:
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.inventory.entitiesGrid.euiDataGrid.lastSeen",
          defaultMessage: "{date} @ {time}",
          values: {
            date: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
              value: entity[columnEntityTableId],
              month: "short",
              day: "numeric",
              year: "numeric"
            }),
            time: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
              value: entity[columnEntityTableId],
              hour12: false,
              hour: "2-digit",
              minute: "2-digit",
              second: "2-digit"
            })
          }
        });
      case _common.ENTITY_DISPLAY_NAME:
        return /*#__PURE__*/_react.default.createElement(_entity_name.EntityName, {
          entity: entity
        });
      default:
        return entity[columnId] || '';
    }
  }, [entities, onFilterByType]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    });
  }
  const currentPage = pageIndex + 1;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.inventoryEntitiesGridLabel', {
      defaultMessage: 'Inventory entities grid'
    }),
    columns: (0, _grid_columns.getColumns)({
      showAlertsColumn
    }),
    columnVisibility: columnVisibility,
    rowCount: entities.length,
    renderCellValue: renderCellValue,
    gridStyle: {
      border: 'horizontal',
      header: 'shade'
    },
    toolbarVisibility: {
      showColumnSelector: false,
      showSortSelector: false,
      additionalControls: {
        left: {
          prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.inventory.entitiesGrid.euiDataGrid.headerLeft",
            defaultMessage: "Showing {currentItems} of {total} {boldEntites}",
            values: {
              currentItems: /*#__PURE__*/_react.default.createElement("strong", null, Math.min(entities.length, pageIndex * PAGE_SIZE + 1), "-", Math.min(entities.length, PAGE_SIZE * currentPage)),
              total: entities.length,
              boldEntites: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.inventory.entitiesGrid.euiDataGrid.headerLeft.entites', {
                defaultMessage: 'Entities'
              }))
            }
          }))
        }
      }
    },
    sorting: {
      columns: [{
        id: sortField,
        direction: sortDirection
      }],
      onSort
    },
    pagination: {
      pageIndex,
      pageSize: PAGE_SIZE,
      onChangeItemsPerPage: () => {},
      onChangePage,
      pageSizeOptions: []
    }
  });
}