"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityName = EntityName;
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-shared-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _entity_icon = require("../../entity_icon");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EntityName({
  entity
}) {
  const {
    services: {
      telemetry,
      share
    }
  } = (0, _use_kibana.useKibana)();
  const assetDetailsLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  const serviceOverviewLocator = share === null || share === void 0 ? void 0 : share.url.locators.get('serviceOverviewLocator');
  const handleLinkClick = (0, _react.useCallback)(() => {
    telemetry.reportEntityViewClicked({
      view_type: 'detail',
      entity_type: entity['entity.type']
    });
  }, [entity, telemetry]);
  const getEntityRedirectUrl = (0, _react.useCallback)(() => {
    const type = entity[_common.ENTITY_TYPE];
    // For service, host and container type there is only one identity field
    const identityField = Array.isArray(entity[_common.ENTITY_IDENTITY_FIELDS]) ? entity[_common.ENTITY_IDENTITY_FIELDS][0] : entity[_common.ENTITY_IDENTITY_FIELDS];
    const identityValue = entity[identityField];
    switch (type) {
      case 'host':
      case 'container':
        return assetDetailsLocator === null || assetDetailsLocator === void 0 ? void 0 : assetDetailsLocator.getRedirectUrl({
          assetId: identityValue,
          assetType: type
        });
      case 'service':
        return serviceOverviewLocator === null || serviceOverviewLocator === void 0 ? void 0 : serviceOverviewLocator.getRedirectUrl({
          serviceName: identityValue,
          environment: [entity[_common.SERVICE_ENVIRONMENT] || undefined].flat()[0]
        });
    }
  }, [entity, assetDetailsLocator, serviceOverviewLocator]);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "entityNameLink",
      href: getEntityRedirectUrl(),
      onClick: handleLinkClick
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 0
    }, /*#__PURE__*/_react.default.createElement(_entity_icon.EntityIcon, {
      entity: entity
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      "data-test-subj": "entityNameDisplayName"
    }, entity[_common.ENTITY_DISPLAY_NAME]))))
  );
}