"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BadgeFilterWithPopover = BadgeFilterWithPopover;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BadgeFilterWithPopover({
  field,
  value,
  onFilter,
  label
}) {
  const [isOpen, setIsOpen] = (0, _react2.useState)(false);
  const theme = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
      "data-test-subj": "inventoryBadgeFilterWithPopoverButton",
      color: "hollow",
      onClick: () => setIsOpen(state => !state),
      onClickAriaLabel: _i18n.i18n.translate('xpack.inventory.badgeFilterWithPopover.openPopoverBadgeLabel', {
        defaultMessage: 'Open popover'
      })
    }, label || value),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false)
  }, /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "inventoryBadgeFilterWithPopoverTitle"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "inventoryBadgeFilterWithPopoverContent",
    responsive: false,
    gutterSize: "xs",
    css: (0, _react.css)`
            font-family: ${theme.euiTheme.font.familyCode};
          `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
                font-weight: bold;
              `
  }, field, ":")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("span", {
    className: "eui-textBreakWord"
  }, value)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGrid, {
    responsive: false,
    columns: 2
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "inventoryBadgeFilterWithPopoverFilterForButton",
    iconType: "plusInCircle",
    onClick: onFilter
  }, _i18n.i18n.translate('xpack.inventory.badgeFilterWithPopover.filterForButtonEmptyLabel', {
    defaultMessage: 'Filter for'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "inventoryBadgeFilterWithPopoverCopyValueButton",
    iconType: "copyClipboard",
    onClick: () => (0, _eui.copyToClipboard)(value)
  }, _i18n.i18n.translate('xpack.inventory.badgeFilterWithPopover.copyValueButtonEmptyLabel', {
    defaultMessage: 'Copy value'
  }))))));
}