"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataContextMenu = AddDataContextMenu;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_kibana = require("../../../hooks/use_kibana");
var _buttons = require("../../shared/add_data_buttons/buttons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddDataContextMenu() {
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const {
    services: {
      share,
      telemetry
    }
  } = (0, _use_kibana.useKibana)();
  const onboardingLocator = share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    iconType: "indexOpen",
    onClick: () => setPopoverOpen(prevState => !prevState),
    "data-test-subj": "inventoryAddDataHeaderContextMenu"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _buttons.addDataTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowDown"
  }))));
  function reportButtonClick(journey) {
    telemetry.reportInventoryAddData({
      view: 'add_data_button',
      journey
    });
  }
  const panels = [{
    id: 0,
    title: _buttons.addDataTitle,
    items: [{
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, _buttons.associateServiceLogsItem), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "popout"
      }))),
      key: 'associateServiceLogs',
      href: _buttons.ASSOCIATE_LOGS_LINK,
      'data-test-subj': 'inventoryHeaderMenuAddDataAssociateServiceLogs',
      target: '_blank',
      onClick: () => {
        reportButtonClick('associate_existing_service_logs');
      }
    }, {
      name: _buttons.addDataItem,
      key: 'addData',
      href: onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.getRedirectUrl({
        category: ''
      }),
      icon: 'plusInCircle',
      'data-test-subj': 'inventoryHeaderMenuAddData',
      onClick: () => {
        reportButtonClick('add_data');
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "inventoryHeaderMenuAddDataPopover",
    button: button,
    isOpen: popoverOpen,
    closePopover: () => setPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
}