"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseIdentityFieldValuesToKql = parseIdentityFieldValuesToKql;
var _common = require("@kbn/observability-shared-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function parseIdentityFieldValuesToKql({
  entity,
  operator = 'AND'
}) {
  const mapping = [];
  const identityFields = entity[_common.ENTITY_IDENTITY_FIELDS];
  if (identityFields) {
    const fields = [identityFields].flat();
    fields.forEach(field => {
      if (field in entity) {
        mapping.push(`${[field]}: "${entity[field]}"`);
      }
    });
  }
  return mapping.join(` ${operator} `);
}